/*  Title:      src/unicode_tool.scala
    Author:     Fabian Huch, TU Muenchen

Isabelle unicode command-line tool.
*/

package isabelle.unicode


import isabelle._
import java.io.{BufferedReader, InputStreamReader}


object Unicode_Tool {
  /* Isabelle tool wrapper */

  val isabelle_tool =
    Isabelle_Tool("unicode", "print unicode representation of Isabelle sources",
      Scala_Project.here, { args =>
        val getopts = Getopts("""
Usage: isabelle unicode [FILE]

  Print given file or stdin input in unicode representation.
""")
        val more_args = getopts(args)
        val content =
          more_args match {
            case file :: Nil => File.read(Path.explode(file))
            case Nil => new BufferedReader(new InputStreamReader(System.in)).readLine()
            case _ => getopts.usage()
          }

        val progress = new Console_Progress()
        progress.echo(Symbol.decode(content))
      })
}

class Tools extends Isabelle_Scala_Tools(Unicode_Tool.isabelle_tool)
